package com.example.sefinsa_app;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.Point;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Display;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.RelativeLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.RegistroCredito;
import com.example.sefinsa_app.utilities.HorizontalScroll;
import com.example.sefinsa_app.utilities.VerticalScroll;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class TableActivity extends AppCompatActivity implements HorizontalScroll.ScrollViewListener, VerticalScroll.ScrollViewListener {


    private ArrayList<RegistroCredito> pagos, pagosFiltrados;
    private ArrayList<Modalidad> modalidades;
    private VolleyS vs;
    private RequestQueue requestQueue;

    private static int SCREEN_HEIGHT;
    private static int SCREEN_WIDTH;
    RelativeLayout relativeLayoutMain;

    RelativeLayout relativeLayoutA;
    RelativeLayout relativeLayoutB;
    RelativeLayout relativeLayoutC;
    RelativeLayout relativeLayoutD;

    TableLayout tableLayoutA;
    TableLayout tableLayoutB;
    TableLayout tableLayoutC;
    TableLayout tableLayoutD;

    TableRow tableRow;
    TableRow tableRowB;

    HorizontalScroll horizontalScrollViewB;
    HorizontalScroll horizontalScrollViewD;

    VerticalScroll scrollViewC;
    VerticalScroll scrollViewD;

    private AutoCompleteTextView acModalidad;
    private ArrayAdapter<Modalidad> modalidadesAdapter;

    private String modalidad_id = "";
    private int previousLength;
    private boolean backSpace;

    /*
         This is for counting how many columns are added in the row.
    */
    int tableColumnCountB= 0;

    /*
         This is for counting how many row is added.
    */
    int tableRowCountC= 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_table);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        /*
            Mandatory Content
         */
        relativeLayoutMain= findViewById(R.id.relativeLayoutMain);
        getScreenDimension();
        initializeRelativeLayout();
        initializeScrollers();
        initializeTableLayout();
        horizontalScrollViewB.setScrollViewListener(this);
        horizontalScrollViewD.setScrollViewListener(this);
        scrollViewC.setScrollViewListener(this);
        scrollViewD.setScrollViewListener(this);
        addRowToTableA();
        initializeRowForTableB();

        /*
            Till Here.
         */

        acModalidad = findViewById(R.id.acModalidad);

        pagos = new ArrayList<RegistroCredito>();
        modalidades = new ArrayList<Modalidad>();

        getPagos();
        getModalidades();

        modalidadesAdapter = new ArrayAdapter<Modalidad>(this, android.R.layout.simple_dropdown_item_1line, modalidades);
        acModalidad.setThreshold(1);
        acModalidad.setAdapter(modalidadesAdapter);
        acModalidad.setImeOptions(EditorInfo.IME_FLAG_NO_EXTRACT_UI);


        acModalidad.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Modalidad modalidad = modalidadesAdapter.getItem(i);
                modalidad_id = modalidad.getId();

            }

        });

        acModalidad.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !modalidad_id.equals("")) {
                    acModalidad.setText("");
                    modalidad_id = "";
                }

            }
        });

        /*  There is two unused functions
            Have a look on these functions and try to recreate and use it.
            createCompleteColumn();
            createCompleteRow();
        */
        addColumnsToTableB("Dirección", 0);
        addColumnsToTableB("Telefóno", 1);
        addColumnsToTableB("Aval", 2);
        addColumnsToTableB("Dirección", 3);
        addColumnsToTableB("Telefóno", 4);
        addColumnsToTableB("Monto", 5);
        addColumnsToTableB("Pago", 6);

        for(int i=1; i<=20; i++){
            addColumnsToTableB("Sem. " + i, i + 6);
        }

    }

    private void getPagos()
    {
        /*dialog = new ProgressDialog(getActivity(),  R.style.AppCompatAlertDialogStyle);
        dialog.setMessage("Trayendo pagos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();*/

        vs = VolleyS.getInstance(this);
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "reporteRegistroCredito");
            data.put("modalidad", "2");
        } catch (JSONException e) {
            e.printStackTrace();
        }


        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {

                            //String data = response.get("data").toString();

                            JSONArray data = (JSONArray) response.get("data");
                            //  dialog.cancel();

                           /* pagosAdapter.clear();*/
                            pagos.clear();

                            for(int i = 0; i < data.length(); i++){

                                JSONObject obj = data.getJSONObject(i);


                                Gson gson = new Gson();
                                RegistroCredito pago = gson.fromJson(obj.toString(), RegistroCredito.class);

                                pagos.add(pago);

                                initializeRowForTableD(i);
                                addRowToTableC(pago.getNumero_tarjeton() + " " + pago.getNombre_completo());

                                initializeRowForTableD(i);
                                addColumnToTableAtD(i, pago.getDireccion());
                                addColumnToTableAtD(i, pago.getTelefono());
                                addColumnToTableAtD(i, pago.getNombre_aval());
                                addColumnToTableAtD(i, pago.getDireccion_aval());
                                addColumnToTableAtD(i, pago.getTelefono_aval());
                                addColumnToTableAtD(i, pago.getMonto_prestado());
                                addColumnToTableAtD(i, pago.getPago_semanal());
                                addColumnToTableAtD(i, pago.getSemana1().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana2().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana3().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana4().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana5().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana6().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana7().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana8().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana9().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana10().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana11().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana12().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana13().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana14().split(" ")[0]);
                                addColumnToTableAtD(i, pago.getSemana15().split(" ")[0]);
                                addColumnToTableAtD(i, (pago.getSemana16() == null) ? "" : pago.getSemana16().split(" ")[0]);
                                addColumnToTableAtD(i, (pago.getSemana17() == null) ? "" : pago.getSemana17().split(" ")[0]);
                                addColumnToTableAtD(i, (pago.getSemana18() == null) ? "" : pago.getSemana18().split(" ")[0]);
                                addColumnToTableAtD(i, (pago.getSemana19() == null) ? "" : pago.getSemana19().split(" ")[0]);
                                addColumnToTableAtD(i, (pago.getSemana20() == null) ? "" : pago.getSemana20().split(" ")[0]);



                               /* for(int j=0; j<tableColumnCountB; j++){
                                    addColumnToTableAtD(i, pago.getNumero_tarjeton() + i + " ! " + j);
                                }*/
                               /* addColumnToTableAtD(0, pago.getDireccion() + i + " ! ");
                                addColumnToTableAtD(1, pago.getTelefono_aval() + i + " ! ");*/

                                //Log.d("pago", pago.getNumero_tarjeton());


                            }
                            /*SharedPreferences.Editor editor = sesion.edit();
                            editor.putString("prestamosData", response.get("data").toString());
                            editor.commit();*/

                           /* pagosAdapter.addAll(pagos);
                            pagosAdapter.notifyItemRangeChanged(pagos.size(), 1);*/

                           /* shimmer.startShimmer();
                            shimmer.setVisibility(View.GONE);
                            recyclerView.setVisibility(View.VISIBLE);*/


                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                String body;
                String statusCode = String.valueOf(error.networkResponse.statusCode);
                if(error.networkResponse.data!=null) {
                    body = new String(error.networkResponse.data, StandardCharsets.UTF_8);
                    Log.e("BODY", body);
                }

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);

    }

    private void getModalidades()
    {
        vs = VolleyS.getInstance(this);
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "semanasActivas");

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlConfiguraciones, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {

                            JSONArray data = (JSONArray) response.get("data");

                            for(int i = 0; i < data.length(); i++){

                                JSONObject obj = data.getJSONObject(i);

                                Gson gson = new Gson();
                                Modalidad modalidad = gson.fromJson(obj.toString(), Modalidad.class);

                                Log.d("MOD", modalidad.getId());
                                modalidades.add(modalidad);

                            }


                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                String body;
                String statusCode = String.valueOf(error.networkResponse.statusCode);
                if(error.networkResponse.data!=null) {
                    body = new String(error.networkResponse.data, StandardCharsets.UTF_8);
                    Log.e("body", body);
                }

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }

    private void getScreenDimension(){
        WindowManager wm= (WindowManager) getApplicationContext().getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        SCREEN_WIDTH= size.x;
        SCREEN_HEIGHT = size.y;
    }

    private void initializeRelativeLayout(){
        relativeLayoutA= new RelativeLayout(getApplicationContext());
        relativeLayoutA.setId(R.id.relativeLayoutA);
        relativeLayoutA.setPadding(0,0,0,0);

        relativeLayoutB= new RelativeLayout(getApplicationContext());
        relativeLayoutB.setId(R.id.relativeLayoutB);
        relativeLayoutB.setPadding(0,0,0,0);

        relativeLayoutC= new RelativeLayout(getApplicationContext());
        relativeLayoutC.setId(R.id.relativeLayoutC);
        relativeLayoutC.setPadding(0,0,0,0);

        relativeLayoutD= new RelativeLayout(getApplicationContext());
        relativeLayoutD.setId(R.id.relativeLayoutD);
        relativeLayoutD.setPadding(0,0,0,0);

        relativeLayoutA.setLayoutParams(new RelativeLayout.LayoutParams(SCREEN_WIDTH/5,SCREEN_HEIGHT/10));
        this.relativeLayoutMain.addView(relativeLayoutA);


        RelativeLayout.LayoutParams layoutParamsRelativeLayoutB= new RelativeLayout.LayoutParams(SCREEN_WIDTH- (SCREEN_WIDTH/5), SCREEN_HEIGHT/10);
        layoutParamsRelativeLayoutB.addRule(RelativeLayout.RIGHT_OF, R.id.relativeLayoutA);
        relativeLayoutB.setLayoutParams(layoutParamsRelativeLayoutB);
        this.relativeLayoutMain.addView(relativeLayoutB);

        RelativeLayout.LayoutParams layoutParamsRelativeLayoutC= new RelativeLayout.LayoutParams(SCREEN_WIDTH/5, SCREEN_HEIGHT - (SCREEN_HEIGHT/5));
        layoutParamsRelativeLayoutC.addRule(RelativeLayout.BELOW, R.id.relativeLayoutA);
        relativeLayoutC.setLayoutParams(layoutParamsRelativeLayoutC);
        this.relativeLayoutMain.addView(relativeLayoutC);

        RelativeLayout.LayoutParams layoutParamsRelativeLayoutD= new RelativeLayout.LayoutParams(SCREEN_WIDTH- (SCREEN_WIDTH/5), SCREEN_HEIGHT - (SCREEN_HEIGHT/5));
        layoutParamsRelativeLayoutD.addRule(RelativeLayout.BELOW, R.id.relativeLayoutB);
        layoutParamsRelativeLayoutD.addRule(RelativeLayout.RIGHT_OF, R.id.relativeLayoutC);
        relativeLayoutD.setLayoutParams(layoutParamsRelativeLayoutD);
        this.relativeLayoutMain.addView(relativeLayoutD);

    }

    private void initializeScrollers(){
        horizontalScrollViewB= new HorizontalScroll(getApplicationContext());
        horizontalScrollViewB.setPadding(0,0,0,0);

        horizontalScrollViewD= new HorizontalScroll(getApplicationContext());
        horizontalScrollViewD.setPadding(0,0,0,0);

        scrollViewC= new VerticalScroll(getApplicationContext());
        scrollViewC.setPadding(0,0,0,0);

        scrollViewD= new VerticalScroll(getApplicationContext());
        scrollViewD.setPadding(0,0,0,0);

        horizontalScrollViewB.setLayoutParams(new ViewGroup.LayoutParams(SCREEN_WIDTH- (SCREEN_WIDTH/5), SCREEN_HEIGHT/5));
        scrollViewC.setLayoutParams(new ViewGroup.LayoutParams(SCREEN_WIDTH/5 ,SCREEN_HEIGHT - (SCREEN_HEIGHT/5)));
        scrollViewD.setLayoutParams(new ViewGroup.LayoutParams(SCREEN_WIDTH- (SCREEN_WIDTH/5), SCREEN_HEIGHT - (SCREEN_HEIGHT/5) ));
        horizontalScrollViewD.setLayoutParams(new ViewGroup.LayoutParams(SCREEN_WIDTH- (SCREEN_WIDTH/5), SCREEN_HEIGHT - (SCREEN_HEIGHT/5) ));

        this.relativeLayoutB.addView(horizontalScrollViewB);
        this.relativeLayoutC.addView(scrollViewC);
        this.scrollViewD.addView(horizontalScrollViewD);
        this.relativeLayoutD.addView(scrollViewD);

    }

    private  void initializeTableLayout(){
        tableLayoutA= new TableLayout(getApplicationContext());
        tableLayoutA.setPadding(0,0,0,0);
        tableLayoutB= new TableLayout(getApplicationContext());
        tableLayoutB.setPadding(0,0,0,0);
        tableLayoutB.setId(R.id.tableLayoutB);
        tableLayoutC= new TableLayout(getApplicationContext());
        tableLayoutC.setPadding(0,0,0,0);
        tableLayoutD= new TableLayout(getApplicationContext());
        tableLayoutD.setPadding(0,0,0,0);

        TableLayout.LayoutParams layoutParamsTableLayoutA= new TableLayout.LayoutParams(SCREEN_WIDTH/5, SCREEN_HEIGHT/5);
        tableLayoutA.setLayoutParams(layoutParamsTableLayoutA);
        tableLayoutA.setBackgroundColor(getResources().getColor(R.color.light));
        this.relativeLayoutA.addView(tableLayoutA);

        TableLayout.LayoutParams layoutParamsTableLayoutB= new TableLayout.LayoutParams(SCREEN_WIDTH -(SCREEN_WIDTH/5), SCREEN_HEIGHT/5);
        tableLayoutB.setLayoutParams(layoutParamsTableLayoutB);
        tableLayoutB.setBackgroundColor(getResources().getColor(R.color.light));
        this.horizontalScrollViewB.addView(tableLayoutB);

        TableLayout.LayoutParams layoutParamsTableLayoutC= new TableLayout.LayoutParams(SCREEN_WIDTH/5, SCREEN_HEIGHT - (SCREEN_HEIGHT/5));
        tableLayoutC.setLayoutParams(layoutParamsTableLayoutC);
        tableLayoutC.setBackgroundColor(getResources().getColor(R.color.light));
        this.scrollViewC.addView(tableLayoutC);

        TableLayout.LayoutParams layoutParamsTableLayoutD= new TableLayout.LayoutParams(TableLayout.LayoutParams.MATCH_PARENT, TableLayout.LayoutParams.MATCH_PARENT);
        tableLayoutD.setLayoutParams(layoutParamsTableLayoutD);
        this.horizontalScrollViewD.addView(tableLayoutD);

    }

    @Override
    public void onScrollChanged(HorizontalScroll scrollView, int x, int y, int oldx, int oldy) {
        if(scrollView == horizontalScrollViewB){
            horizontalScrollViewD.scrollTo(x,y);
        }
        else if(scrollView == horizontalScrollViewD){
            horizontalScrollViewB.scrollTo(x, y);
        }

    }

    @Override
    public void onScrollChanged(VerticalScroll scrollView, int x, int y, int oldx, int oldy) {
        if(scrollView == scrollViewC){
            scrollViewD.scrollTo(x,y);
        }
        else if(scrollView == scrollViewD){
            scrollViewC.scrollTo(x,y);
        }
    }

    private void addRowToTableA(){
        tableRow= new TableRow(getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow= new TableRow.LayoutParams(SCREEN_WIDTH/5, SCREEN_HEIGHT/5);
        tableRow.setLayoutParams(layoutParamsTableRow);
        TextView label_date = new TextView(getApplicationContext());
        label_date.setGravity(Gravity.CENTER_VERTICAL | Gravity.CENTER_HORIZONTAL);
        label_date.setGravity(Gravity.CENTER);
        label_date.setText("Tarjetón / Cliente");
        label_date.setTypeface(label_date.getTypeface(), Typeface.BOLD);
        label_date.setTextColor(getResources().getColor(R.color.black));
        tableRow.setGravity(Gravity.CENTER_HORIZONTAL);
        label_date.setTextSize(getResources().getDimension(R.dimen.cell_text_size));
        tableRow.addView(label_date);
        this.tableLayoutA.addView(tableRow);
    }

    private void initializeRowForTableB(){
        tableRowB= new TableRow(getApplicationContext());
        tableRow.setPadding(0,0,0,0);
        this.tableLayoutB.addView(tableRowB);
    }

    private synchronized void addColumnsToTableB(String text, final int id){
        tableRow= new TableRow(getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow= new TableRow.LayoutParams(SCREEN_WIDTH/5, SCREEN_HEIGHT/5);
        tableRow.setPadding(3,3,3,4);
        tableRow.setLayoutParams(layoutParamsTableRow);
        TextView label_date = new TextView(getApplicationContext());
        label_date.setTextColor(getResources().getColor(R.color.black));
        label_date.setGravity(Gravity.CENTER_VERTICAL | Gravity.CENTER_HORIZONTAL);
        label_date.setText(text);
        label_date.setTypeface(label_date.getTypeface(), Typeface.BOLD);
        label_date.setTextSize(getResources().getDimension(R.dimen.cell_text_size));
        this.tableRow.addView(label_date);
        this.tableRow.setTag(id);
        this.tableRowB.addView(tableRow);
        tableColumnCountB++;
    }

    private synchronized void addRowToTableC(String text){
        TableRow tableRow1= new TableRow(getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow1= new TableRow.LayoutParams(SCREEN_WIDTH/5, SCREEN_HEIGHT/5);
        tableRow1.setPadding(3,3,3,4);
        tableRow1.setLayoutParams(layoutParamsTableRow1);
        //tableRow1.setGravity(Gravity.CENTER_VERTICAL | Gravity.CENTER_HORIZONTAL);
        TextView label_date = new TextView(getApplicationContext());
        label_date.setTextColor(getResources().getColor(R.color.black));
        label_date.setGravity(Gravity.CENTER_VERTICAL | Gravity.CENTER_HORIZONTAL);
        label_date.setText(text);
        label_date.setTextSize(getResources().getDimension(R.dimen.cell_text_size));
        tableRow1.addView(label_date);

        TableRow tableRow= new TableRow(getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow= new TableRow.LayoutParams(SCREEN_WIDTH/5, SCREEN_HEIGHT/5);
        tableRow.setPadding(0,0,0,0);
        tableRow.setLayoutParams(layoutParamsTableRow);
        tableRow.addView(tableRow1);
        this.tableLayoutC.addView(tableRow, tableRowCountC);
        tableRowCountC++;
    }

    private synchronized void initializeRowForTableD(int pos){
        TableRow tableRowB= new TableRow(getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow= new TableRow.LayoutParams(TableRow.LayoutParams.WRAP_CONTENT, SCREEN_HEIGHT/5);
        tableRowB.setPadding(0,0,0,0);
        tableRowB.setLayoutParams(layoutParamsTableRow);
        this.tableLayoutD.addView(tableRowB, pos);
    }

    private synchronized void addColumnToTableAtD(final int rowPos, String text){
        TableRow tableRowAdd= (TableRow) this.tableLayoutD.getChildAt(rowPos);
        tableRow= new TableRow(getApplicationContext());
        TableRow.LayoutParams layoutParamsTableRow= new TableRow.LayoutParams(SCREEN_WIDTH/5, SCREEN_HEIGHT/5);
        tableRow.setPadding(3,3,3,4);
        tableRow.setBackground(getResources().getDrawable(R.drawable.cell_background));
        tableRow.setLayoutParams(layoutParamsTableRow);
       // tableRow.setGravity(Gravity.CENTER_VERTICAL | Gravity.CENTER_HORIZONTAL);

        TextView label_date = new TextView(getApplicationContext());
        label_date.setGravity(Gravity.CENTER_VERTICAL | Gravity.CENTER_HORIZONTAL);
        label_date.setText(text);
        label_date.setTextSize(getResources().getDimension(R.dimen.cell_text_size));
        label_date.setTextColor(getResources().getColor(R.color.black));

        tableRow.setTag(label_date);
        this.tableRow.addView(label_date);
        tableRowAdd.addView(tableRow);
    }

    private void createCompleteColumn(String value){
        int i=0;
        int j=tableRowCountC-1;
        for(int k=i; k<=j; k++){
            addColumnToTableAtD(k, value);
        }
    }

    private void createCompleteRow(String value){
        initializeRowForTableD(0);
        int i=0;
        int j=tableColumnCountB-1;
        int pos= tableRowCountC-1;
        for(int k=i; k<=j; k++){
            addColumnToTableAtD(pos, value);
        }
    }


}